#ifndef FSYMBOL_TABLE_H
#define FSYMBOL_TABLE_H

#include <iostream>
#include <map>
#include <exception>
#include "Funkcije.hpp"

/* pomocna klasa kojom predstavljamo tablicu simbola */
class FuncSymbolTable {
private:
    /* jedini atribut klase je mapa u kojoj uparujemo naziv promenljive sa 
     * sa formulom. Moramo da koristimo pokazivace da bi metode nad formulama
     * mogle polimorfno da se izvrsavaju. 
     */
    std::map<std::string, Funkcija*> _vars;
public:
    /* podrazumevani konstruktor sa praznom implementacijom */
    FuncSymbolTable() {}
    /* klasa cuva dinamicke resurse, pa moramo da obezbedimo kostruktor kopije, destruktor i 
     * operator dodele. 
     */
    FuncSymbolTable(const FuncSymbolTable& fs);
    ~FuncSymbolTable();
    
    FuncSymbolTable& operator =(const FuncSymbolTable& fs);

    /* javni interfejs klase */
    bool VariableDefined(const std::string& s) const;
    double VariableValue(const std::string& s, double x) const;
    Funkcija* GetVariable(const std::string& s) const;
    void DefineVariable(const std::string& s, Funkcija* f);
};

#endif
